/******************************************************************************
Ootake

 [Option.cpp]
	X^[gɐݒύX邽߂̃tH[

Copyright(C)2006-2020 Kitao Nakamura.
	ŁEpłJȂƂ͕K\[XR[hYtĂB
	̍ۂɎł܂܂̂ŁAЂƂƂm点ƍKłB
	Iȗp͋ւ܂B
	Ƃ́uGNU General Public License(ʌOp_)vɏ܂B

******************************************************************************/
#include <string.h>
#include "Option.h"
#include "resource.h"
#include "Startup.h"
#include "WinMain.h"
#include "App.h"
#include "JoyPad.h"
#include "ScreenD3D.h"
#include "PsgSetting.h"

#define LINE_LEN	48
#define N_LINES 	23

enum OptionComponent
{
	BUTTON_HELP = 1,
	BUTTON_CDDATIMING,
	BUTTON_FUNCKEY,
	BUTTON_PADCONFIG,
	BUTTON_RESUME,
	COMBOBOX_SCREENTYPE,
	COMBOBOX_DRAWMODE,
	COMBOBOX_SOUNDBUFFER,
	BUTTON_LIGHT,
	BUTTON_DEFAULT,
	BUTTON_SET,
};

static HWND			_hWndC[BUTTON_SET]; //eR|[lg̃nh

static HBRUSH		_hMyb; //uVF
static HFONT		_hFontB; //{^ptHg

static Uint32		_FontWidth;
static Uint32		_FontHeight;
static const char*	_pCaption = "\"Ootake\" Setting";
static HINSTANCE	_hInstance = NULL;
static HWND 		_hWnd = NULL;


static Sint32		_ScreenType = -1; //߂l(肵ꍇ1`7Ԃ)BLZȂ-1Bݒ蒆0B
static Sint32*		_pScreenType;
static Sint32		_DrawMode = -1; //߂l(肵ꍇ1`12Ԃ)BLZȂ-1Bݒ蒆0B
static Sint32*		_pDrawMode;
static Sint32		_SoundBuffer = -1; //߂l(肵ꍇ1`12Ԃ)BLZȂ-1Bݒ蒆0B
static Sint32*		_pSoundBuffer;


/* tHg̍擾 */
static Uint32
get_font_height(
	HWND			hWnd)
{
	HDC 			hDC;
	HFONT			hFont;
	HFONT			hFontOld;
	TEXTMETRIC		tm;

	hDC 	 = GetDC(hWnd);
	hFont	 = (HFONT)GetStockObject(OEM_FIXED_FONT);	 /* Œsb`tHg */
	hFontOld = (HFONT)SelectObject(hDC, hFont);

	GetTextMetrics(hDC, &tm);

	SelectObject(hDC, hFontOld);
	DeleteObject(hFont);
	ReleaseDC(hWnd, hDC);

	return (Uint32)(tm.tmHeight);
}

/* tHg̉擾 */
static Uint32
get_font_width(
	HWND			hWnd)
{
	HDC 			hDC;
	HFONT			hFont;
	HFONT			hFontOld;
	TEXTMETRIC		tm;

	hDC 	 = GetDC(hWnd);
	hFont	 = (HFONT)GetStockObject(OEM_FIXED_FONT);	 /* Œsb`tHg */
	hFontOld = (HFONT)SelectObject(hDC, hFont);

	GetTextMetrics(hDC, &tm);

	SelectObject(hDC, hFontOld);
	DeleteObject(hFont);
	ReleaseDC(hWnd, hDC);

	return (Uint32)tm.tmAveCharWidth;
}


static void
set_window_size(
	HWND			hWnd)
{
	RECT		rc;
	Uint32		wndW = _FontWidth  * LINE_LEN;
	Uint32		wndH = _FontHeight * N_LINES +_FontHeight/2 -1;

	SetRect(&rc, 0, 0, wndW, wndH);
	AdjustWindowRectEx(&rc, GetWindowLong(hWnd, GWL_STYLE),
						GetMenu(hWnd) != NULL, GetWindowLong(hWnd, GWL_EXSTYLE));
	wndW = rc.right - rc.left;
	wndH = rc.bottom - rc.top;
	GetWindowRect(STARTUP_GetHwnd(), &rc);
	MoveWindow(hWnd, rc.left, rc.bottom - wndH, wndW, wndH, TRUE);
}


static void
update_window(
	HWND			hWnd)
{
	HDC 			hDC;
	HFONT			hFont;
	HFONT			hFontOld;
	PAINTSTRUCT 	ps;
	Uint32			x;
	Uint32			y;

	/* `揀 */
	hDC = BeginPaint(hWnd, &ps);
	SetBkMode(hDC, OPAQUE);	//̔wihԂ
	SetBkColor(hDC, RGB(64,128,64));
	SetTextColor(hDC, RGB(240,240,240));
	hFont = (HFONT)GetStockObject(OEM_FIXED_FONT);
	hFontOld = (HFONT)SelectObject(hDC, hFont);

	x = _FontWidth*2 +1;
	y = _FontHeight/2;
	TextOut(hDC, x, y, "Important Setting  dvȐݒ", 29);
	y += _FontHeight*9 +1;
	TextOut(hDC, x, y, "Push button, and Explanation is displayed.", 42);
	y += _FontHeight;
	TextOut(hDC, x, y, "{^Ɛ\܂B", 34);

	y = _FontHeight*13 -1;
	TextOut(hDC, x, y, "Video Setting  rfI̐ݒ", 31);
	y += _FontHeight*5;
	TextOut(hDC, x, y, "Sound Setting  TEh̐ݒ", 33);

	/* I */
	EndPaint(hWnd, &ps);
	SelectObject(hDC, hFontOld);
	DeleteObject(hFont);
	ReleaseDC(hWnd, hDC);
}


static LRESULT CALLBACK
option_wnd_proc(
	HWND		hWnd,
	UINT		uMsg,
	WPARAM		wParam,
	LPARAM		lParam)
{
	BOOL		bOk;
	Sint32		screenType;
	Sint32		psgQuality;
	MSG			msg;

	switch(uMsg)
	{
	case WM_CREATE:
		EnableWindow(STARTUP_GetHwnd(), FALSE);//X^[gAbvEBhE𖳌ă[_ɁB
		_hFontB = CreateFont(  0,						// B0 = ftHg
		                       0,						// B0Ȃ獂ɍ
    		                   0,						// px
        		               0,						// x[XCƂ̊px
            		           FW_NORMAL,				// 
                		       FALSE,					// C^bN
	                    	   FALSE,					// A_[C
		                       FALSE,					// ł
    		                   0,						// {舵ƂSHIFTJIS_CHARSETɂB
        		               0,						// o͐x
            		           0,						// NbsOx
                		       0,						// o͕i
                    		   0,						// sb`ƃt@~[
		                       ""						// ̖
							); //p̃ftHgtHgɐݒ
		_FontWidth	= get_font_width(hWnd);
		_FontHeight = get_font_height(hWnd);
		set_window_size(hWnd);
		break;

	case WM_PAINT:
		update_window(hWnd);
		break;

	case WM_KEYDOWN:
		if (wParam == VK_ESCAPE)
		{
			OPTION_Deinit();
			return 0;
		}
		break;

	case WM_COMMAND:
		switch(LOWORD(wParam))
		{
			case BUTTON_HELP: //v2.77ǉ
				MessageBox(hWnd,
					"For the important setting of Ootake, please use the four buttons on    \n"
					"the left.    \n"
					"In lower side of the setting screen, the setting of Video and Sound    \n"
					"can be set. When you press the [Set]button(bottom-right of window),    \n"
					"it will reflect the setting.    \n"
					"In addition, the menu appears when you click on the game screen    \n"
					"during game play. It can be a variety of settings. Please select   \n"
					"[Info -> Manual-English] menu(rightmost of menu), and the    \n"
					"explanation of each menu is displayed.    \n"
					"\n"
					"In Japanese language\n"
					"̂S̃{^ŁAOotake̓ɕKvƂȂ{Iȁidvȁj   \n"
					"ݒs܂B\n"
					"ݒʉ́ArfIƃTEh̐ݒ́AԉE[Set]{^   \n"
					"ƁAݒ肪f܂B   \n"
					"̐ݒ́AQ[vCɉʂNbNƌ郁j[   \n"
					"ݒ肷邱Ƃł܂Bej[̐́Aj[ԉE   \n"
					"[Info -> Manual-Japanese]IĂB   ",
					"About Ootake Setting", MB_OK);
				break;

			case BUTTON_CDDATIMING: //v2.77ǉ
				MessageBox(hWnd,
					"The timing value of the CD sound (CD-DA and ADPCM) is set    \n"
					"automatically to match the sound to the picture.    \n"
					"The set completion is about 60 seconds. Please close other heavy    \n"
					"applications for an accurate measurement now.    \n"
					"* Some PC may not behave like a real machine because the    \n"
					"  processing will be lost if the Windows or Video Card is set to    \n"
					"  \"Power Save mode\". In that case, please set \"Maximum    \n"
					"  Performance mode\" instead of \"Power Save mode\".    \n"
					"\n"
					"In Japanese language\n"
					"g̃p\RɂāAGCDiCD-DA,ADPCMj̃Y   \n"
					"NȂ悤ɁA^C~Olݒ肵܂B\n"
					"ݒ芮܂Ŗ60bԊ|܂B̊ԁAOotakeȂ   \n"
					"߂ɁȀdAvP[V͕ĂB   \n"
					"WindowsrfIJ[h̐ݒ肪uȓd́vɂȂĂƏ   \n"
					"@Ă܂@l̓oȂPC܂B̍ۂ́uȓd́v   \n"
					"@ł͂ȂuptH[}Xőv̐ݒɂȂĂB   ",
					"About \"CD-DA Play Timing\" Setting", MB_OK);
				psgQuality = 0;
				PSGSETTING_Init(_hInstance, &psgQuality); //PsgSettingEBhE\
				while (psgQuality == 0) //_CAOʂԂ܂Ń[v
				{ 
					GetMessage(&msg ,NULL, 0, 0);
					TranslateMessage(&msg);
					DispatchMessage(&msg);
				}
				if (psgQuality >= 1) //LZł͂ȂAR̃{^̂ꂩĂꍇ
				{
					APP_SetPsgQuality(psgQuality);
					if (psgQuality == 1) //xDI񂾏ꍇ
					{
						if (APP_GetRemoveDisplayLagFrame() > 1)
							APP_SetRemoveDisplayLagFrame(1); //y邽ߒx΍􏈗ŒɁBv2.89
					} else if (psgQuality == 4) //ōݒI񂾏ꍇ
					{
						//if (APP_GetRemoveDisplayLagFrame() >= 1) //x΍􏈗ItȂꍇ
						//	APP_SetRemoveDisplayLagFrame(3); //y邽ߒx΍􏈗ōݒɁBv2.89 2.98ōݒIł1̂܂܂ɂB
					}
					screenType = SendMessage(GetDlgItem(hWnd, COMBOBOX_SCREENTYPE), CB_GETCURSEL, 0, 0) + 1;
					switch (screenType) //EBhE[htXN[[h̐ݒύXĂꍇAŐݒm肷B
					{
					case 1:	APP_SetStartFullScreen(FALSE); break;
					case 2:
						APP_SetMagnification(2); //x2{ɐݒ
						APP_SetStartFullScreen(FALSE);
						break;
					case 3:
						APP_SetMagnification(3); //x3{ɐݒ
						APP_SetStartFullScreen(FALSE);
						break;
					case 4:
						APP_SetMagnification(4); //x4{ɐݒ
						APP_SetStartFullScreen(FALSE);
						break;
					case 5:
						APP_SetMagnification(5); //x5{ɐݒ
						APP_SetStartFullScreen(FALSE);
						break;
					case 6:	APP_SetStartFullScreen(TRUE); break;
					case 7:
						APP_SetFullScreen800(); //800x600ɐݒ
						APP_SetStartFullScreen(TRUE);
						break;
					}
					APP_UpdateScreenMode(FALSE, FALSE); //Q[EBhE\
					SetForegroundWindow(WINMAIN_GetHwnd()); //Q[EBhEOɕ\
					if (APP_GetFullScreen())
						Sleep(3000); //Windows̉ʐ؂ւ̏ĂԂɌvn߂Ă܂ƏŌvɂȂĂ܂̂łRb҂B
					else
						Sleep(1000); //Window[h̏ꍇ͂PbB
					bOk = APP_SetCddaTimingAuto(TRUE); //^C~Oݒ
					APP_SaveConfig();//ݒۑ
					if (bOk)
					{
						MessageBox(WINMAIN_GetHwnd(),
							"While playing a game, the menu (click on the game screen)    \n"
							"[Audio -> Adjust CD-DA (for Sync) -> Adjust CD-DA Auto Set]    \n"
							"can be used to set this setting.    \n"
							"If there is a gap of CD-DA, please use it.    \n"
							"\n"
							"In Japanese language\n"
							"̐ݒ́AQ[j[iQ[ʂNbNj   \n"
							"uAudio -> Adjust CD-DA (for Sync) -> Adjust CD-DA Auto Setv   \n"
							"ݒ肷邱Ƃł܂BYꍇAĐݒ肵Ă݂   \n"
							"B   \n"
							"Q[ɂẮA@łYĂ̂܂B   \n"
							"@OotakẽQ[ȏꍇAm点΁A\Ȍ   \n"
							"@łAC܂B   ",
							"About \"CD-DA Play Timing\" Setting", MB_OK);
					}
					if (APP_GetFullScreen()) //tXN[[hꍇAfXNgbv\֖߂B
					{
						APP_SetFullScreen(FALSE);
						APP_UpdateScreenMode(FALSE, TRUE);
						APP_SetFullScreen(TRUE);
					}
					WINMAIN_SetMiniSize(); //Q[EBhEŏ
					SetForegroundWindow(hWnd); //ݒEBhEOɕ\
				}
				break;
		
			case BUTTON_FUNCKEY: //v2.77ǉ
				bOk = MessageBox(hWnd,
					"Witn Ootake, you can set the \"Function Button\" on your joypad.    \n"
					"[ Set the button you press with your left hand index finger(e.g.     \n"
					"  L2 button at the PS-Pad) to the \"Function Button\". It is    \n"
					"  very useful because it can be various settings at hand. ]    \n"
					"Function Button + [I]  button -> Switching of Auto-fire(Turbo)    \n"
					"Function Button + [II] button -> Switching of Auto-fire(Turbo)    \n"
					"Function Button + [RUN] button -> Switching the Game Soft.    \n"
					"Function Button + [SELECT] button -> Shooting of Screenshots    \n"
					"Function Button + Up,Down,Left,Right -> Audio Volume control    \n"
					"+ Operate while Pressing the Function Button    \n"
					"Press \"Yes\" button, and Setup-Screen appears.    \n\n"
					"In Japanese language\n"
					"OotakéAWCpbh\"t@NV{^\"ݒł܂B   \n"
					"[ lwŉ{^iႦPS^ȂL2{^jt@N   \n"
					"  V{^ɐݒ肷ƁA茳ŐFXݒł̂ŕ֗łB]   \n"
					"t@NV{^{ I{^ or II{^cuAːݒ̐ؑցv   \n"
					"t@NV{^{ RUN{^cuQ[̐ؑցv   \n"
					"t@NV{^{ SELECT{^cuXN[Vbgۑv   \n"
					"t@NV{^{ \L[cuʂ̒߁v   \n"
					"L̑́At@NV{^Ȃ瑀삵܂B   \n"
					"u͂vƐݒʂo܂̂ŁA{^ĂB   ",
					"About \"Function Button\" Setting", MB_YESNO);
				if (bOk == IDYES)
				{
					APP_SetShortcutButton(_hWnd, _hInstance, 6);
					APP_SaveConfig();//ݒۑ
				}
				break;
		
			case BUTTON_PADCONFIG: //v2.77ǉ
				bOk = MessageBox(hWnd,
					"In real machine \"PC Engine(TG16)\", three types of game pad (    \n"
					"[2 button pad],[3 button pad],and [6 button pad]) exists.    \n"
					"In Ootake, setting of the button is set by three separate    \n"
					"settings. And, settings of three types are saved.    \n"
					"Press \"Yes\" button, and Setup-Screen appears. Please set it.    \n"
					"Most games are played with [2 button pad] setting.    \n"
					"+In real machine, [RUN] or [SELECT] either is selected at    \n"
					" [III]button of [3 button pad]. In Ootake, set [IIIr]button and    \n"
					" [IIIs]button, and they can be used at the same time.    \n\n"
					"In Japanese language\n"
					"PCGWi@jɂ́AuQ{^vuR{^vuU{^v   \n"
					"Rނ̃Q[pbh݂܂B   \n"
					"Ootakeł́A{^ݒRޕʁXɐݒ肵AʁXɕۑ܂B   \n"
					"u͂vƐݒʂo܂̂ŁAuSetv{^Đݒ   \n"
					"ĂBقƂǂ̃Q[́uQ{^vݒŗVт܂B   \n"
					"uR{^pbhv́A@ł͂R{^ڂuRUN,SELECTǂ   \n"
					"@؂ւĎgpvłAOotakeł́ARUNSELECTʁX   \n"
					"@ɂꂼuIIIr{^,IIIs{^ƂĐݒv܂B   ",
					"About \"PCE Pad Controller\" Setting", MB_YESNO);
				if (bOk == IDYES)
				{
					//Q{^CR{^CU{^pbhRg[P`T܂őSďBv2.87
					//iv2.79Õo[WŃWCpbh𕡐qO肵ꍇARg[Q`T܂łɗ]Ȑݒ肪c듮̋ꂠB邽߂ɂŏj
					//APP_InitPadConfiguration(); v2.94ݒʂDefault{^ݒûŁAł͏Ȃ悤ɂB

					//pbhݒptH[\悤ɂBv2.94
					bOk = APP_ConfigurePad(_hWnd, _hInstance, 1); //KeyConfig_CAO\BftHg̐ݒPadio[1Bv2.94
					if (bOk)
						MessageBox(hWnd,
							"Pad configuration is complete.    \n"
							"In the game for 2-5 players, connect multiple game pads to your    \n"
							"PC. Or, use the keyboard.    \n"
							"And, you can set this pad setting even during the game with    \n"
							"[Input -> Configure PCE Pad] menu.    \n"
							"(The menu appears when you click on the game screen during    \n"
							"game play.)    \n\n"
							"In Japanese language\n"
							"pbhݒ肪܂B   \n"
							"ȂAQl`TlvCΉ̃Q[ł́Ap\RɃQ[pbh   \n"
							"Ȃ邩AL[{[h̗pŁA@l̃vCł܂B   \n"
							"Rg[[ݒ́AQ[j[iQ[ʂNbN   \n"
							"o܂j̉EQڂɂuInput -> Configure PCE Padvj[   \n"
							"s܂B   ",
							"About \"PCE Pad Controller\" Setting", MB_OK);
				}
				break;

			case BUTTON_RESUME: //v2.77ǉ
				bOk = MessageBox(hWnd,
					"Ootake has \"Resume Mode\" that performing a state save    \n"
					"automatically. When the game is started in the next time,    \n"
					"you can play from the continuation of the last end. In addition,    \n"
					"the settings(Sound Volume and Auto-fire, etc.) are loaded in    \n"
					"every game.    \n"
					"For using \"Resume Mode\", click the [File -> Set Resume] menu,    \n"
					"and \"Resume Mode\" switch of the playing game become ON.    \n"
					"(The menu appears when you click on the game screen during    \n"
					"game play.)    \n"
					"If you want to automatically turn on the \"Resume Mode\" in all    \n"
					"of the games, press [Yes]button(at bottom of this window).    \n"
					"If you want to manually turn on(off) to each game, press    \n"
					"[No]button(at bottom of this window).    \n"
					"\n"
					"In Japanese language\n"
					"OotakéAQ[IɎŃXe[gZ[usuW[@\v   \n"
					"܂B̃Q[JnɁAOIvCłA   \n"
					"TEhʂA˓̐ݒAQ[ɓǂݍ܂܂B   \n"
					"uW[@\v́AW[@\gQ[vCɁA   \n"
					"j[iQ[ʂNbNjA[File -> Set Resume]j[   \n"
					"Iă`FbN邱ƂŃIɂł܂B   \n"
					"SẴQ[ŁuW[@\vIɃIɂꍇ́A   \n"
					"́u͂vĂBL̂悤Ɏ蓮ŃQ[ɃIIt   \n"
					"ꍇ́AuvĂB   ",
					"About \"Resume(Auto Save) Mode\" Setting", MB_YESNO);
				if (bOk == IDYES)
					APP_SetAutoResumeMode(TRUE);
				else
					APP_SetAutoResumeMode(FALSE);
				APP_SaveConfig();//ݒۑ
				break;
		
			case COMBOBOX_SCREENTYPE:
			case COMBOBOX_DRAWMODE:
			case COMBOBOX_SOUNDBUFFER:
				if (HIWORD(wParam) == CBN_CLOSEUP)
					SetFocus(GetDlgItem(hWnd, BUTTON_SET));//OK{^ɃtH[JX
				break;

			case BUTTON_LIGHT:
				SendMessage(_hWndC[COMBOBOX_SCREENTYPE], CB_SETCURSEL, 6, 0);
				SendMessage(_hWndC[COMBOBOX_DRAWMODE], CB_SETCURSEL, 10, 0);
				SendMessage(_hWndC[COMBOBOX_SOUNDBUFFER], CB_SETCURSEL, 7, 0);
				break;

			case BUTTON_DEFAULT:
				SendMessage(_hWndC[COMBOBOX_SCREENTYPE], CB_SETCURSEL, 1, 0);
				SendMessage(_hWndC[COMBOBOX_DRAWMODE], CB_SETCURSEL, 0, 0);
				SendMessage(_hWndC[COMBOBOX_SOUNDBUFFER], CB_SETCURSEL, 5, 0);
				break;

			case BUTTON_SET:
				//߂lݒ
				_ScreenType = SendMessage(GetDlgItem(hWnd, COMBOBOX_SCREENTYPE), CB_GETCURSEL, 0, 0) + 1;
				_DrawMode = SendMessage(GetDlgItem(hWnd, COMBOBOX_DRAWMODE), CB_GETCURSEL, 0, 0) + 1;
				_SoundBuffer = SendMessage(GetDlgItem(hWnd, COMBOBOX_SOUNDBUFFER), CB_GETCURSEL, 0, 0) + 1;
				OPTION_Deinit();
				return 0;
		}
		break;

	case WM_CLOSE:
		OPTION_Deinit();
		return 0;
	}

	return DefWindowProc(hWnd, uMsg, wParam, lParam);
}


static BOOL
option_main()
{
	WNDCLASS	wc;
	HWND		hWnd;
	RECT		rc;
	Uint32		x;
	Uint32		y;
	HWND		hWndTmp;
	char		pCaption[64];
	
	strcpy_s(pCaption, 64, "\"Ootake v");
	strcat_s(pCaption, 64, APP_GetSoftVersionChar());
	strcat_s(pCaption, 64, "\" Setting");
	
	ZeroMemory(&wc, sizeof(wc));
	wc.style		 = 0;
	wc.lpfnWndProc	 = option_wnd_proc;
	wc.cbClsExtra	 = 0;
	wc.cbWndExtra	 = 0;
	wc.hInstance	 = _hInstance;
	wc.hIcon		 = LoadIcon(_hInstance, MAKEINTRESOURCE(IDI_ICON)); //ACRǂݍ݁Bv2.00XV
	wc.hCursor		 = LoadCursor(NULL, IDC_ARROW);
	_hMyb = CreateSolidBrush(RGB(64,128,64)); //uV
	wc.hbrBackground = _hMyb;
	wc.lpszMenuName  = "";
	wc.lpszClassName = _pCaption;

	if (RegisterClass(&wc) == 0)
		return FALSE;

	hWnd = CreateWindow(
		_pCaption,
		pCaption,
		WS_SYSMENU | WS_CAPTION,
		CW_USEDEFAULT,
		CW_USEDEFAULT,
		0,
		0,
		STARTUP_GetHwnd(),
		NULL,
		_hInstance,
		NULL
	);

	if (hWnd == NULL)
		return FALSE;

	_hWnd = hWnd;

	//CD-DA Timing{^쐬
	x = _FontWidth*2;
	y = _FontHeight +_FontHeight/2 +3;
	hWndTmp = CreateWindow(
		"BUTTON", "Set CD-DA Play Timing",
		WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON,
		x, y, _FontWidth*38, _FontHeight*2-3,
		_hWnd, (HMENU)BUTTON_CDDATIMING, _hInstance, NULL
	);
	SendMessage(hWndTmp, WM_SETFONT, (WPARAM)_hFontB, MAKELPARAM(TRUE, 0));//tHgݒ

	//Help{^쐬
	x += _FontWidth*40;
	hWndTmp = CreateWindow(
		"BUTTON", "?",
		WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON,
		x, y, _FontWidth*4, _FontHeight*2-3,
		_hWnd, (HMENU)BUTTON_HELP, _hInstance, NULL
	);
	SendMessage(hWndTmp, WM_SETFONT, (WPARAM)_hFontB, MAKELPARAM(TRUE, 0));

	//FunctionButton{^쐬
	x = _FontWidth*2;
	y += _FontHeight*2;
	hWndTmp = CreateWindow(
		"BUTTON", "Set Function-Button",
		WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON,
		x, y, _FontWidth*38, _FontHeight*2-3,
		_hWnd, (HMENU)BUTTON_FUNCKEY, _hInstance, NULL
	);
	SendMessage(hWndTmp, WM_SETFONT, (WPARAM)_hFontB, MAKELPARAM(TRUE, 0));

	//PadConfig{^쐬
	y += _FontHeight*2;
	hWndTmp = CreateWindow(
		"BUTTON", "Set Button of PCE Pad Controller",
		WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON,
		x, y, _FontWidth*38, _FontHeight*2-3,
		_hWnd, (HMENU)BUTTON_PADCONFIG, _hInstance, NULL
	);
	SendMessage(hWndTmp, WM_SETFONT, (WPARAM)_hFontB, MAKELPARAM(TRUE, 0));

	//Resume{^쐬
	y += _FontHeight*2;
	hWndTmp = CreateWindow(
		"BUTTON", "Set Resume (Auto Save) Mode",
		WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON,
		x, y, _FontWidth*38, _FontHeight*2-3,
		_hWnd, (HMENU)BUTTON_RESUME, _hInstance, NULL
	);
	SendMessage(hWndTmp, WM_SETFONT, (WPARAM)_hFontB, MAKELPARAM(TRUE, 0));

	//tXN[orEBhE[hؑ֗pR{{bNX쐬
	x = _FontWidth*2;
	y = _FontHeight*14;
	_hWndC[COMBOBOX_SCREENTYPE] = CreateWindow(
		"COMBOBOX", "",
		WS_CHILD | WS_VISIBLE | WS_VSCROLL | CBS_DROPDOWNLIST,
		x, y, _FontWidth*42, _FontHeight*11,
		_hWnd, (HMENU)COMBOBOX_SCREENTYPE, _hInstance, NULL
	);
	SendMessage(_hWndC[COMBOBOX_SCREENTYPE], WM_SETFONT, (WPARAM)_hFontB, MAKELPARAM(TRUE, 0));//tHgݒ
	SendMessage(_hWndC[COMBOBOX_SCREENTYPE], CB_ADDSTRING, 0, (LPARAM)"Start Window Mode");
	SendMessage(_hWndC[COMBOBOX_SCREENTYPE], CB_ADDSTRING, 0, (LPARAM)"Start Window (x2)");
	SendMessage(_hWndC[COMBOBOX_SCREENTYPE], CB_ADDSTRING, 0, (LPARAM)"Start Window (x3)");
	SendMessage(_hWndC[COMBOBOX_SCREENTYPE], CB_ADDSTRING, 0, (LPARAM)"Start Window (x4)");
	SendMessage(_hWndC[COMBOBOX_SCREENTYPE], CB_ADDSTRING, 0, (LPARAM)"Start Window (x5)");
	SendMessage(_hWndC[COMBOBOX_SCREENTYPE], CB_ADDSTRING, 0, (LPARAM)"Start FullScreen Mode");
	SendMessage(_hWndC[COMBOBOX_SCREENTYPE], CB_ADDSTRING, 0, (LPARAM)"Start FullScreen (800x600 60Hz)");
	if (APP_GetStartFullScreen())
		SendMessage(_hWndC[COMBOBOX_SCREENTYPE], CB_SETCURSEL, 5, 0);
	else
		SendMessage(_hWndC[COMBOBOX_SCREENTYPE], CB_SETCURSEL, 0, 0);

	//TV or RGBؑ֗pR{{bNX쐬
	x = _FontWidth*2;
	y += _FontHeight*2;
	_hWndC[COMBOBOX_DRAWMODE] = CreateWindow(
		"COMBOBOX", "",
		WS_CHILD | WS_VISIBLE | WS_VSCROLL | CBS_DROPDOWNLIST,
		x, y, _FontWidth*42, _FontHeight*19,
		_hWnd, (HMENU)COMBOBOX_DRAWMODE, _hInstance, NULL
	);
	SendMessage(_hWndC[COMBOBOX_DRAWMODE], WM_SETFONT, (WPARAM)_hFontB, MAKELPARAM(TRUE, 0));
	SendMessage(_hWndC[COMBOBOX_DRAWMODE], CB_ADDSTRING, 0, (LPARAM)"Special Scanlined (Sharp&Gentle)");
	SendMessage(_hWndC[COMBOBOX_DRAWMODE], CB_ADDSTRING, 0, (LPARAM)"TV Scanlined (Smooth, Fast)");
	SendMessage(_hWndC[COMBOBOX_DRAWMODE], CB_ADDSTRING, 0, (LPARAM)"TV Scanlined (Blur, Fast)");
	SendMessage(_hWndC[COMBOBOX_DRAWMODE], CB_ADDSTRING, 0, (LPARAM)"Horizontal Scanlined");
	SendMessage(_hWndC[COMBOBOX_DRAWMODE], CB_ADDSTRING, 0, (LPARAM)"Horizontal Scanlined 2 (Sharp)");
	SendMessage(_hWndC[COMBOBOX_DRAWMODE], CB_ADDSTRING, 0, (LPARAM)"Horizontal Scanlined 3 (More)");
	SendMessage(_hWndC[COMBOBOX_DRAWMODE], CB_ADDSTRING, 0, (LPARAM)"Horizontal Scanlined F (Fast)");
	SendMessage(_hWndC[COMBOBOX_DRAWMODE], CB_ADDSTRING, 0, (LPARAM)"Non-Scanlined (Fast)");
	SendMessage(_hWndC[COMBOBOX_DRAWMODE], CB_ADDSTRING, 0, (LPARAM)"Non-Scanlined 2 (Sharp, Fast)");
	SendMessage(_hWndC[COMBOBOX_DRAWMODE], CB_ADDSTRING, 0, (LPARAM)"Non-Scanlined 3 (Soft, Fast)");
	SendMessage(_hWndC[COMBOBOX_DRAWMODE], CB_ADDSTRING, 0, (LPARAM)"Non-Scanlined TV (Smooth, Fast)");
	SendMessage(_hWndC[COMBOBOX_DRAWMODE], CB_ADDSTRING, 0, (LPARAM)"Non-Scanlined TV (Blur, Fast)");
	switch (APP_GetScanlineType())
	{
		case  0: SendMessage(_hWndC[COMBOBOX_DRAWMODE], CB_SETCURSEL, 7, 0); break;
		case  1: SendMessage(_hWndC[COMBOBOX_DRAWMODE], CB_SETCURSEL, 0, 0); break;
		case  2: SendMessage(_hWndC[COMBOBOX_DRAWMODE], CB_SETCURSEL, 3, 0); break;
		case  3: SendMessage(_hWndC[COMBOBOX_DRAWMODE], CB_SETCURSEL, 6, 0); break;
		case  4: SendMessage(_hWndC[COMBOBOX_DRAWMODE], CB_SETCURSEL, 1, 0); break;
		case  5: SendMessage(_hWndC[COMBOBOX_DRAWMODE], CB_SETCURSEL, 4, 0); break;
		case  6: SendMessage(_hWndC[COMBOBOX_DRAWMODE], CB_SETCURSEL, 5, 0); break;
		case  7: SendMessage(_hWndC[COMBOBOX_DRAWMODE], CB_SETCURSEL, 8, 0); break;
		case  8: SendMessage(_hWndC[COMBOBOX_DRAWMODE], CB_SETCURSEL, 9, 0); break;
		case  9: SendMessage(_hWndC[COMBOBOX_DRAWMODE], CB_SETCURSEL,10, 0); break;
		case 10: SendMessage(_hWndC[COMBOBOX_DRAWMODE], CB_SETCURSEL,11, 0); break;
		case 11: SendMessage(_hWndC[COMBOBOX_DRAWMODE], CB_SETCURSEL, 2, 0); break;
	}

	//TEhobt@pR{{bNX쐬
	x = _FontWidth*2;
	y = _FontHeight*19;
	_hWndC[COMBOBOX_SOUNDBUFFER] = CreateWindow(
		"COMBOBOX", "",
		WS_CHILD | WS_VISIBLE | WS_VSCROLL | CBS_DROPDOWNLIST,
		x, y, _FontWidth*42, _FontHeight*16,
		_hWnd, (HMENU)COMBOBOX_SOUNDBUFFER, _hInstance, NULL
	);
	SendMessage(_hWndC[COMBOBOX_SOUNDBUFFER], WM_SETFONT, (WPARAM)_hFontB, MAKELPARAM(TRUE, 0));
	SendMessage(_hWndC[COMBOBOX_SOUNDBUFFER], CB_ADDSTRING, 0, (LPARAM)"1.39 Frame Buffer (Low-Lag)");
	SendMessage(_hWndC[COMBOBOX_SOUNDBUFFER], CB_ADDSTRING, 0, (LPARAM)"1.57 Frame Buffer");
	SendMessage(_hWndC[COMBOBOX_SOUNDBUFFER], CB_ADDSTRING, 0, (LPARAM)"1.74 Frame Buffer");
	SendMessage(_hWndC[COMBOBOX_SOUNDBUFFER], CB_ADDSTRING, 0, (LPARAM)"1.92 Frame Buffer");
	SendMessage(_hWndC[COMBOBOX_SOUNDBUFFER], CB_ADDSTRING, 0, (LPARAM)"2.09 Frame Buffer");
	SendMessage(_hWndC[COMBOBOX_SOUNDBUFFER], CB_ADDSTRING, 0, (LPARAM)"2.26 Frame Buffer (Recommend)");
	SendMessage(_hWndC[COMBOBOX_SOUNDBUFFER], CB_ADDSTRING, 0, (LPARAM)"2.44 Frame Buffer");
	SendMessage(_hWndC[COMBOBOX_SOUNDBUFFER], CB_ADDSTRING, 0, (LPARAM)"2.79 Frame Buffer");
	SendMessage(_hWndC[COMBOBOX_SOUNDBUFFER], CB_ADDSTRING, 0, (LPARAM)"2.96 Frame Buffer");
	SendMessage(_hWndC[COMBOBOX_SOUNDBUFFER], CB_ADDSTRING, 0, (LPARAM)"3.13 Frame Buffer");
	SendMessage(_hWndC[COMBOBOX_SOUNDBUFFER], CB_ADDSTRING, 0, (LPARAM)"3.48 Frame Buffer");
	SendMessage(_hWndC[COMBOBOX_SOUNDBUFFER], CB_ADDSTRING, 0, (LPARAM)"4.18 Frame Buffer (HQ but Lag)");
	switch (APP_GetSoundBufferSize())
	{
		case 1024: SendMessage(_hWndC[COMBOBOX_SOUNDBUFFER], CB_SETCURSEL,  0, 0); break;
		case 1152: SendMessage(_hWndC[COMBOBOX_SOUNDBUFFER], CB_SETCURSEL,  1, 0); break;
		case 1280: SendMessage(_hWndC[COMBOBOX_SOUNDBUFFER], CB_SETCURSEL,  2, 0); break;
		case 1408: SendMessage(_hWndC[COMBOBOX_SOUNDBUFFER], CB_SETCURSEL,  3, 0); break;
		case 1536: SendMessage(_hWndC[COMBOBOX_SOUNDBUFFER], CB_SETCURSEL,  4, 0); break;
		case 1664: SendMessage(_hWndC[COMBOBOX_SOUNDBUFFER], CB_SETCURSEL,  5, 0); break;
		case 1792: SendMessage(_hWndC[COMBOBOX_SOUNDBUFFER], CB_SETCURSEL,  6, 0); break;
		case 2048: SendMessage(_hWndC[COMBOBOX_SOUNDBUFFER], CB_SETCURSEL,  7, 0); break;
		case 2176: SendMessage(_hWndC[COMBOBOX_SOUNDBUFFER], CB_SETCURSEL,  8, 0); break;
		case 2304: SendMessage(_hWndC[COMBOBOX_SOUNDBUFFER], CB_SETCURSEL,  9, 0); break;
		case 2560: SendMessage(_hWndC[COMBOBOX_SOUNDBUFFER], CB_SETCURSEL, 10, 0); break;
		case 3072: SendMessage(_hWndC[COMBOBOX_SOUNDBUFFER], CB_SETCURSEL, 11, 0); break;
		default:
			SendMessage(_hWndC[COMBOBOX_SOUNDBUFFER], CB_SETCURSEL, 5, 0); break; //1664
	}

	//Light{^쐬
	x = _FontWidth*2;
	y = _FontHeight*21;
	hWndTmp = CreateWindow(
		"BUTTON", "Light(Fast)",
		WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON,
		x, y, _FontWidth*13, _FontHeight*2-3,
		_hWnd, (HMENU)BUTTON_LIGHT, _hInstance, NULL
	);
	SendMessage(hWndTmp, WM_SETFONT, (WPARAM)_hFontB, MAKELPARAM(TRUE, 0));//tHgݒ

	//Default{^쐬
	x += _FontWidth*14;
	hWndTmp = CreateWindow(
		"BUTTON", "Default(HQ)",
		WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON,
		x, y, _FontWidth*14, _FontHeight*2-3,
		_hWnd, (HMENU)BUTTON_DEFAULT, _hInstance, NULL
	);
	SendMessage(hWndTmp, WM_SETFONT, (WPARAM)_hFontB, MAKELPARAM(TRUE, 0));

	//Set{^쐬
	x = _FontWidth*36;
	y = _FontHeight*21;
	hWndTmp = CreateWindow(
		"BUTTON", "Set",
		WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON,
		x, y, _FontWidth*10, _FontHeight*2-3,
		_hWnd, (HMENU)BUTTON_SET, _hInstance, NULL
	);
	SendMessage(hWndTmp, WM_SETFONT, (WPARAM)_hFontB, MAKELPARAM(TRUE, 0));

	ShowWindow(_hWnd, SW_SHOWNORMAL);
	UpdateWindow(_hWnd);
	GetWindowRect(_hWnd, &rc);
	SetWindowPos(_hWnd, HWND_TOP, rc.left, rc.top, rc.right - rc.left, rc.bottom - rc.top, SWP_FRAMECHANGED);
	ImmAssociateContext(_hWnd, 0); //IME𖳌ɂ

	return TRUE;
}


BOOL
OPTION_Init(
	HINSTANCE	hInstance,
	Sint32*		screenType,
	Sint32*		drawMode,
	Sint32*		soundBuffer)
{
	if (_hInstance != NULL)
		OPTION_Deinit();

	_hInstance = hInstance;

	_pScreenType = screenType;
	_ScreenType = -1;//LZ
	_pDrawMode = drawMode;
	_DrawMode = -1;//LZ
	_pSoundBuffer = soundBuffer;
	_SoundBuffer = -1;//LZ

	return option_main();
}


void
OPTION_Deinit()
{
	if (_hInstance != NULL)
	{
		DestroyWindow(_hWnd);
		_hWnd = NULL;
		UnregisterClass(_pCaption, _hInstance);
		_hInstance = NULL;
		
		DeleteObject(_hFontB); //{^ptHgJ
		DeleteObject(_hMyb); //uVJ
		
		//X^[gAbvEBhEɃtH[JX߂OʂɁB
		EnableWindow(STARTUP_GetHwnd(), TRUE);
		SetForegroundWindow(STARTUP_GetHwnd());
		
		//߂lݒ
		*_pScreenType = _ScreenType;
		*_pDrawMode = _DrawMode;
		*_pSoundBuffer = _SoundBuffer; //̏uԂStartup.c ɐ䂪߂B
	}
}


HWND
OPTION_GetHwnd()
{
	return _hWnd;
}

